<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Sistem extends CI_Controller {
	function __construct() {
		parent::__construct();
	
		 $this->load->model('user_model');
		  $this->load->library(array('session', 'MZA_SecureUrl', 'form_validation', 'email')); 
	}
	
	public function index() {
		if ($this->session->userdata('admin_coba') == FALSE && $this->session->userdata('admin_id') == "") {
			redirect("sistem/login");
		}
		
		$a['page']	= "d_amain";
		$a['data_juli_cppob']			= $this->db->query("SELECT Count(step) as jumlah_7 FROM view_progres_max where step >= '5' AND MONTH(tgl) = 7")->row();
		$a['data_agustus_cppob']		= $this->db->query("SELECT Count(step) as jumlah_8 FROM view_progres_max where step >= '5' AND MONTH(tgl) = 8")->row();
		$a['data_september_cppob']		= $this->db->query("SELECT Count(step) as jumlah_9 FROM view_progres_max where step >= '5' AND MONTH(tgl) = 9")->row();
		$a['data_oktober_cppob']		= $this->db->query("SELECT Count(step) as jumlah_10 FROM view_progres_max where step >= '5' AND MONTH(tgl) = 10")->row();
		$a['data_november_cppob']		= $this->db->query("SELECT Count(step) as jumlah_11 FROM view_progres_max where step >= '5' AND MONTH(tgl) = 11")->row();
		$a['data_desember_cppob']		= $this->db->query("SELECT Count(step) as jumlah_12 FROM view_progres_max where step >= '5' AND MONTH(tgl) = 12")->row();
		



		$a['data_juli_ie']			= $this->db->query("SELECT Count(step) as jumlah_7 FROM view_progres_max where step = '7' AND MONTH(tgl) = 7")->row();
		$a['data_agustus_ie']		= $this->db->query("SELECT Count(step) as jumlah_8 FROM view_progres_max where step = '7' AND MONTH(tgl) = 8")->row();
		$a['data_september_ie']		= $this->db->query("SELECT Count(step) as jumlah_9 FROM view_progres_max where step = '7' AND MONTH(tgl) = 9")->row();
		$a['data_oktober_ie']		= $this->db->query("SELECT Count(step) as jumlah_10 FROM view_progres_max where step = '7' AND MONTH(tgl) = 10")->row();
		$a['data_november_ie']		= $this->db->query("SELECT Count(step) as jumlah_11 FROM view_progres_max where step = '7' AND MONTH(tgl) = 11")->row();
		$a['data_desember_ie']		= $this->db->query("SELECT Count(step) as jumlah_12 FROM view_progres_max where step = '7' AND MONTH(tgl) = 12")->row();
		
		$a['data_umkm_terdaftar']		= $this->db->query("SELECT Count(id_umkm) as umkm_terdaftar FROM tb_umkm")->row();
		$a['data_umkm_cppob']			= $this->db->query("SELECT Count(id_umkm) as umkm_cppob FROM view_progres_max where step >= '5'")->row();
		$a['data_umkm_ie']				= $this->db->query("SELECT Count(id_umkm) as umkm_ie FROM view_progres_max where step = '7'")->row();
		$a['data_fasilitator']			= $this->db->query("SELECT Count(id_user) as umkm_fasilitator FROM t_admin where level = 'User'")->row();
		

		$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
		$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
		$this->load->view('sistem/aaa', $a);
	
	
	}
	public function umkm() {
		if ($this->session->userdata('admin_valid') == FALSE && $this->session->userdata('admin_id_user') == "") {
			redirect("sistem/login");
		}
		
		
		//ambil variabel URL
		$mau_ke					= $this->uri->segment(3);
		$idu					= (decrypt_url ($this->uri->segment(4)));
	
		//ambil variabel Postingan
		$idp								= addslashes($this->input->post('idp'));
		$nama_usaha							= addslashes($this->input->post('nama_usaha'));
		$nama_pemilik						= addslashes($this->input->post('nama_pemilik'));
		$telp								= addslashes($this->input->post('telp'));
		$jenis_produk						= addslashes($this->input->post('jenis_produk'));
		$nama_produk						= addslashes($this->input->post('nama_produk'));
		$linsek								= addslashes($this->input->post('linsek'));

		
			
		if ($mau_ke == "del") {
			$this->db->query("DELETE FROM tb_umkm WHERE id_umkm = '$idu'");
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Dihapus </div>");
			redirect('sistem/umkm');
		} else if ($mau_ke == "add") {
			$a['page']		= "master/l_umkm";
		} else if ($mau_ke == "edt") {
			$a['datpil']	= $this->db->query("SELECT * FROM tb_umkm WHERE id_umkm = '$idu'")->row();	
			$a['page']		= "master/l_umkm";
			
		} else if ($mau_ke == "act_add") {	
			
			$sql = $this->db->query("SELECT * FROM tb_umkm where nama_usaha = '$nama_usaha' AND nama_pemilik = '$nama_pemilik' ");
			$cek_umkm = $sql->num_rows();
			if ($cek_umkm > 0) {
			$this->session->set_flashdata("kk", "<div class=\"alert alert-danger\" id=\"alert\">UMKM dengan Nama Usaha $nama_usaha Sudah ada di sistem, Silakan Cek Kembali</div>");
			redirect(site_url('sistem/umkm'));
			} else {
			$this->db->query("INSERT INTO tb_umkm 
			VALUES 
			(NULL,
			'$nama_usaha',
			'$nama_pemilik',
			'$telp',
			'$jenis_produk',
			'$nama_produk',
			'$linsek')");
			}
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Ditambah</div>");
			redirect('sistem/umkm');
	} else if ($mau_ke == "act_edt") {
			if ($password = md5("-")) {
				$this->db->query("UPDATE tb_umkm SET 
				nama_usaha = '$nama_usaha', 
				nama_pemilik = '$nama_pemilik', 
				telp = '$telp',
				jenis_produk = '$jenis_produk',
				nama_produk = '$nama_produk',
				linsek = '$linsek'
				WHERE id_umkm = '$idp'");
			} else {
				$this->db->query("UPDATE tb_umkm SET 
				nama_usaha = '$nama_usaha', 
				nama_pemilik = '$nama_pemilik', 
				telp = '$telp',
				jenis_produk = '$jenis_produk',
				nama_produk = '$nama_produk',
				linsek = '$linsek'
				WHERE id_umkm = '$idp'");
			}
			
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Diubah </div>");			
			redirect('sistem/umkm');
		} else {
			$a['data']		= $this->db->query("SELECT * FROM tb_umkm ")->result();
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
			$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			$a['page']		= "master/l_umkm";
		}
		
		$this->load->view('sistem/aaa', $a);
	}
	public function fasilitator() {
		if ($this->session->userdata('admin_valid') == FALSE && $this->session->userdata('admin_id_user') == "") {
			redirect("sistem/login");
		}
		
		
		//ambil variabel URL
		$mau_ke					= $this->uri->segment(3);
		$idu					= (decrypt_url ($this->uri->segment(4)));
	
		//ambil variabel Postingan
		$idp						= addslashes($this->input->post('idp'));
		$username					= addslashes($this->input->post('username'));
		$password					= md5(addslashes($this->input->post('password')));
		$level						= addslashes($this->input->post('level'));

		$nama_lengkap				= addslashes($this->input->post('nama_lengkap'));
		$nama_panggilan				= addslashes($this->input->post('nama_panggilan'));
		$kampus						= addslashes($this->input->post('kampus'));
		$semester					= addslashes($this->input->post('semester'));
		$prodi						= addslashes($this->input->post('prodi'));
		$asal						= addslashes($this->input->post('asal'));
		$no_wa						= addslashes($this->input->post('no_wa'));
		
			
		if ($mau_ke == "del") {
			$this->db->query("DELETE FROM t_admin WHERE id_user = '$idu'");
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Dihapus </div>");
			redirect('sistem/fasilitator');
		} else if ($mau_ke == "add") {
			$a['page']		= "master/l_fasilitator";
		} else if ($mau_ke == "edt") {
			$a['datpil']	= $this->db->query("SELECT * FROM t_admin WHERE id_user = '$idu'")->row();	
			$a['page']		= "master/l_fasilitator";
			
		} else if ($mau_ke == "act_add") {	
			
			$sql = $this->db->query("SELECT * FROM t_admin where nama_lengkap = '$nama_lengkap' ");
			$cek_user = $sql->num_rows();
			if ($cek_user > 0) {
			$this->session->set_flashdata("kk", "<div class=\"alert alert-danger\" id=\"alert\">fasilitator dengan Nama $nama_lengkap Sudah ada di sistem, Silakan Cek Kembali</div>");
			redirect(site_url('sistem/fasilitator'));
			} else {
			$this->db->query("INSERT INTO t_admin 
			VALUES 
			(NULL,
			'$username', 
			'$password',
			'$level',
			'$nama_lengkap',
			'$nama_panggilan',
			'$kampus',
			'$semester',
			'$prodi',
			'$asal',
			'$no_wa')");
			}
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Ditambah</div>");
			redirect('sistem/fasilitator');
	} else if ($mau_ke == "act_edt") {
			if ($password = md5("-")) {
				$this->db->query("UPDATE t_admin SET
				username = '$username',  
				nama_lengkap = '$nama_lengkap', 
				nama_panggilan = '$nama_panggilan', 
				kampus = '$kampus',
				semester = '$semester',
				prodi = '$prodi',
				asal = '$asal',
				no_wa = '$no_wa'
				WHERE id_user = '$idp'");
			} else {
				$this->db->query("UPDATE t_admin SET 
				username = '$username', 
				password = '$password', 
				nama_lengkap = '$nama_lengkap', 
				nama_panggilan = '$nama_panggilan', 
				kampus = '$kampus',
				semester = '$semester',
				prodi = '$prodi',
				asal = '$asal',
				no_wa = '$no_wa'
				WHERE id_user = '$idp'");
			}
			
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Diubah </div>");			
			redirect('sistem/fasilitator');
		} else {
			$a['data']		= $this->db->query("SELECT * FROM t_admin where level='User' ")->result();
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
		$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			$a['page']		= "master/l_fasilitator";
		}
		
		$this->load->view('sistem/aaa', $a);
	}



	public function proses() {
		if ($this->session->userdata('admin_valid') == FALSE && $this->session->userdata('admin_id_user') == "") {
			redirect("sistem/login");
		}
		
		
		//ambil variabel URL
		$mau_ke					= $this->uri->segment(3);
		$idu					= (decrypt_url ($this->uri->segment(4)));
	
		//ambil variabel Postingan
		$idp						= addslashes($this->input->post('idp'));
		$id_umkm					= addslashes($this->input->post('id_umkm'));
		$id_user					= addslashes($this->input->post('id_user'));
		
			
		if ($mau_ke == "del") {
			$this->db->query("DELETE FROM tb_proses WHERE id_proses = '$idu'");
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Dihapus </div>");
			redirect('sistem/proses');
		} else if ($mau_ke == "add") {
			$a['page']		= "proses/l_proses";
		
			
		} else if ($mau_ke == "act_add") {	
			
			$sql = $this->db->query("SELECT * FROM view_umkm_join_progres where id_user = '$id_user' AND hitung IS NULL ");
			$cek_proses = $sql->num_rows();
			if ($cek_proses > 0) {
			$this->session->set_flashdata("kk", "<div class=\"alert alert-danger\" id=\"alert\">fasilitator dengan Nama $nama_lengkap Sudah ada di sistem, Silakan Cek Kembali</div>");
			redirect(site_url('sistem/proses'));
			} else {
			$this->db->query("INSERT INTO tb_proses 
			VALUES 
			(NULL,
			'$id_umkm', 
			'$id_user')");
			}
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Ditambah</div>");
			redirect('sistem/proses');
	} else {
		$a['data_umkm']				= $this->db->query("SELECT * FROM view_left_join_umkm where id_proses is NULL")->result();
		$a['data_fasilitator']		= $this->db->query("SELECT * FROM view_fasilitator_union where level = 'User' AND id_proses is NULL OR verif = 2")->result();
		
		$a['data']					= $this->db->query("SELECT * FROM view_umkm_join_progres")->result();

		$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
		$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
		$a['page']		= "proses/l_proses";
		}
		
		$this->load->view('sistem/aaa', $a);
	}

	public function progres() {
		if ($this->session->userdata('admin_valid') == FALSE && $this->session->userdata('admin_id_user') == "") {
			redirect("sistem/login");
		}
		else if ($this->session->userdata('admin_level') == "Admin") 
		{
			$a['page']		= "progres/l_progres";
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
			$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			$a['data']		= $this->db->query("SELECT * FROM view_umkm_join_progres  order by id_proses desc ")->result();
			
		}
		else if ($this->session->userdata('admin_level') == "User") 
		{
			$a['page']		= "progres/l_progres";
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
			$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			$a['data']		= $this->db->query("SELECT * FROM view_umkm_join_progres where id_user ='".$this->session->userdata('admin_id_user')."' order by id_proses desc ")->result();
			
		}
			
		$this->load->view('sistem/aaa', $a);
	
	
	}

	public function progres_detail() {
		if ($this->session->userdata('admin_valid') == FALSE && $this->session->userdata('admin_id_user') == "") {
			redirect("sistem/login");
		}
		//ambil variabel URL
		$mau_ke					= $this->uri->segment(4);
		$idu1					= $this->uri->segment(3);
		$idu2					= (decrypt_url ($this->uri->segment(5)));
		$idu3					= (decrypt_url ($this->uri->segment(3)));
		$idu4					= (encrypt_url ($this->uri->segment(3)));
		
		//ambil variabel Postingan
		$idp							= addslashes($this->input->post('idp'));
		$id_proses						= addslashes($this->input->post('id_proses'));
		$step							= addslashes($this->input->post('step'));
		$kendala						= addslashes($this->input->post('kendala'));
		$ket							= addslashes($this->input->post('ket'));
		$file_progres					= addslashes($this->input->post('file_progres'));
		$verif							= addslashes($this->input->post('verif'));
		$ket_verif						= addslashes($this->input->post('ket_verif'));
		$tgl							= addslashes($this->input->post('tgl'));

		//upload config 
		$config['upload_path'] 		= './upload/bukti';
		$config['allowed_types'] 	= 'gif|jpg|png|pdf|doc|docx|rar';
		$config['max_size']			= '3000000';
		$config['max_width']  		= '3000000';
		$config['max_height'] 		= '3000000';

		$this->load->library('upload', $config);
			
		if ($mau_ke == "del") {
			$this->db->query("DELETE FROM tb_progres WHERE id_progres = '$idu2'");
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Dihapus </div>");
			redirect('sistem/progres_detail/'.$idu1);
	
			
		} else if ($mau_ke == "add") {
			$a['page']		= "progres/l_progres_detail";
		} else if ($mau_ke == "edt") {
			$a['datpil']	= $this->db->query("SELECT * FROM tb_progres WHERE id_proses = 5")->row();	
			$a['page']		= "progres/l_progres_detail";
			
		
		} else if ($mau_ke == "act_add") {
			$sql = $this->db->query("SELECT * FROM tb_progres where step = 1  AND kendala = 'Tidak Ada Kendala' AND id_proses = $idu1 group by id_proses");
			$cek_no_1 = $sql->num_rows();
		
			$sqlili = $this->db->query("SELECT * FROM tb_progres where id_proses = $idu1   AND step = $step - 1 AND verif = 1  group by id_proses");
			$cek_no_2 = $sqlili->num_rows();
		
			$sqlcek = $this->db->query("SELECT * FROM tb_progres where id_proses = $idu1  AND kendala = 'Tidak Ada Kendala' AND step = $step  AND verif = 1  group by id_proses");
			$cek_duplikat = $sqlcek->num_rows();
			
			$sqlcekken = $this->db->query("SELECT * FROM tb_progres where id_proses = $idu1  AND kendala = 'Tidak Ada Kendala' AND step = $step  AND verif = 0 group by id_proses");
			$cek_duplikat_kendala = $sqlcekken->num_rows();
		
			$sqli = $this->db->query("SELECT * FROM view_progres_maping where id_proses = $idu1  AND hitung = 7 ");
			$cek_selesai = $sqli->num_rows();
			if ($cek_no_1 == 0) 
			if ($this->upload->do_upload('file_progres')) {
			
				$up_data	 	= $this->upload->data();
				
					$this->db->query("INSERT INTO tb_progres 
						VALUES (NULL, 
						'$id_proses', 
						'$step', 
						'$kendala',
						'$ket',  
						'".$up_data['file_name']."',
						'$verif',
						'$ket_verif',
						'$tgl'
						)");
						$this->session->set_flashdata("kk", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Disimpan</div>");
						redirect(site_url('sistem/progres_detail/'.$idu4));
					} 
			if ($cek_no_2 == 0) 
			{
				$this->session->set_flashdata("kk", "<div class=\"alert alert-danger\" id=\"alert\">Anda Tidak Bisa Input Progres Karena Tahap Sebelumnya Belum Selesai</div>");
				redirect(site_url('sistem/progres_detail/'.$idu4));
				} 
			if ($cek_duplikat >= 1) 
			{
				$this->session->set_flashdata("kk", "<div class=\"alert alert-danger\" id=\"alert\">Anda Tidak Bisa Input Progres Karena Sudah Ada di Sistem</div>");
				redirect(site_url('sistem/progres_detail/'.$idu4));
				} 
			if ($cek_duplikat_kendala == 1) 
			{
				$this->session->set_flashdata("kk", "<div class=\"alert alert-danger\" id=\"alert\">Anda Tidak Bisa Input Progres Karena Sudah Ada di Sistem</div>");
				redirect(site_url('sistem/progres_detail/'.$idu4));
				} 
			if ($cek_selesai > 0) {
				$this->session->set_flashdata("kk", "<div class=\"alert alert-danger\" id=\"alert\">Anda Tidak Bisa Input Progres Karena sudah dinyatakan Selesai</div>");
				redirect(site_url('sistem/progres_detail/'.$idu4));
				} 
			

			if ($this->upload->do_upload('file_progres')) {
				$up_data	 	= $this->upload->data();
				
				$this->db->query("INSERT INTO tb_progres VALUES 
				(NULL, 
				'$id_proses', 
				'$step', 
				'$kendala',
				'$ket',  
				'".$up_data['file_name']."',
				'$verif',
				'$ket_verif',
				'$tgl'
				)");
			} else {
				$this->db->query("INSERT INTO tb_progres VALUES 
				(NULL, 
				'$id_proses', 
				'$step', 
				'$kendala',
				'$ket',  
				'',
				'$verif',
				'$ket_verif',
				'$tgl')");
			}		
			
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Disimpan</div>");
			redirect('sistem/progres_detail/'.$idu4);
	
		} else {
			$a['data']		= $this->db->query("SELECT * FROM view_progres WHERE id_proses = '$idu3' order by id_progres DESC ")->result();
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
			$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			$a['page']		= "progres/l_progres_detail";
		}
		
		$this->load->view('sistem/aaa', $a);
	}


	public function verifikasi() {
		if ($this->session->userdata('admin_valid') == FALSE && $this->session->userdata('admin_id_user') == "") {
			redirect("sistem/login");
		}
		
		
		//ambil variabel URL
		$mau_ke					= $this->uri->segment(3);
		$idu					= (decrypt_url ($this->uri->segment(4)));
	
		//ambil variabel Postingan
		$idp						= addslashes($this->input->post('idp'));
		$verif						= addslashes($this->input->post('verif'));
		$ket_verif					= addslashes($this->input->post('ket_verif'));
		
		
			
		if ($mau_ke == "del") {
			$this->db->query("DELETE FROM tb_progres WHERE id_progres = '$idu'");
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Dihapus </div>");
			redirect('sistem/verifikasi');
	
		} else if ($mau_ke == "edt") {
			$a['datpil']	= $this->db->query("SELECT * FROM tb_progres WHERE id_progres = '$idu'")->row();	
			
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
			$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			
			$a['page']		= "proses/l_verifikasi";
			
		
	} else if ($mau_ke == "act_edt") {
			if ($password = md5("-")) {
				$this->db->query("UPDATE tb_progres SET
				verif = '$verif',  
				ket_verif = '$ket_verif', 
				tgl = NOW() 
				WHERE id_progres = '$idp'");
			} else {
				$this->db->query("UPDATE tb_progres SET 
				verif = '$verif',  
				ket_verif = '$ket_verif',
				tgl = NOW()  
				WHERE id_progres = '$idp'");
			}
			
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Diubah </div>");			
			redirect('sistem/verifikasi');
		} else {
			$a['data_umkm']				= $this->db->query("SELECT * FROM view_left_join_umkm where id_proses is NULL")->result();
		
			$a['data_unverif']		= $this->db->query("SELECT * FROM view_progres where kendala = 'Tidak Ada Kendala' AND verif = 0 ")->result();
			$a['data_verif']		= $this->db->query("SELECT * FROM view_progres where  verif = 1 OR verif = 2 ORDER BY id_progres desc")->result();
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
			$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			
			$a['page']		= "proses/l_verifikasi";
		}
		
		$this->load->view('sistem/aaa', $a);
	}

	public function tindak() {
		if ($this->session->userdata('admin_valid') == FALSE && $this->session->userdata('admin_id_user') == "") {
			redirect("sistem/login");
		}
		
		
		//ambil variabel URL
		$mau_ke					= $this->uri->segment(3);
		$idu					= (decrypt_url ($this->uri->segment(4)));
	
		//ambil variabel Postingan
		$idp						= addslashes($this->input->post('idp'));
		$verif					= addslashes($this->input->post('verif'));
		$ket_verif					= addslashes($this->input->post('ket_verif'));
		
		
			
		if ($mau_ke == "del") {
			$this->db->query("DELETE FROM tb_progres WHERE id_progres = '$idu'");
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Dihapus </div>");
			redirect('sistem/tindak');
	
		} else if ($mau_ke == "edt") {
			$a['datpil']	= $this->db->query("SELECT * FROM tb_progres WHERE id_progres = '$idu'")->row();	
			
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
			$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			
			$a['page']		= "proses/l_tindak";
			
		
	} else if ($mau_ke == "act_edt") {
			if ($password = md5("-")) {
				$this->db->query("UPDATE tb_progres SET
				verif = '$verif', 
				ket_verif = '$ket_verif', 
				tgl = NOW() 
				WHERE id_progres = '$idp'");
			} else {
				$this->db->query("UPDATE tb_progres SET 
				verif = '$verif', 
				ket_verif = '$ket_verif',
				tgl = NOW()  
				WHERE id_progres = '$idp'");
			}
			
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data Berhasil Diubah </div>");			
			redirect('sistem/tindak');
		} else {
			$a['data_umkm']				= $this->db->query("SELECT * FROM view_left_join_umkm where id_proses is NULL")->result();
		
			$a['data_atas']		= $this->db->query("SELECT * FROM view_progres where kendala = 'Ada Kendala' AND verif ='0'")->result();
			$a['data_bawah']		= $this->db->query("SELECT * FROM view_progres where  kendala = 'Ada Kendala' AND verif ='100'")->result();
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
			$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			
			$a['page']		= "proses/l_tindak";
		}
		
		$this->load->view('sistem/aaa', $a);
	}








	public function data_status() {
		if ($this->session->userdata('admin_coba') == FALSE && $this->session->userdata('admin_id') == "") {
			redirect("admin/login");
		}
		else if ($this->session->userdata('admin_level') == "Admin") 
		{
			$a['page']		= "surat_tugas/l_data_surat_tugas";
			$a['data']		= $this->db->query("SELECT * FROM view_status where  nama_ppk != '' ")->result();
			
		}
		else if ($this->session->userdata('admin_level') == "User") 
		{
			$a['page']		= "surat_tugas/l_data_surat_tugas";
			$a['data']		= $this->db->query("SELECT * FROM view_status where  nama_ppk != '' AND  username = '".$this->session->userdata('admin_username')."' ")->result();
			
		}
		$this->load->view('admin/aaa', $a);
	
	
	}
	

	
	/* ============================ KUMPULAN MASTER DATA=========================================== */	
	
   //Kumpulan Controller Cetak//
		public function disposisi_cetak() 	{
		$idu = $this->uri->segment(3);
		$a['datpil1']	= $this->db->query("SELECT * FROM t_surat_masuk WHERE id_sm = '$idu'")->row();	
		$a['datpil2']	= $this->db->query("SELECT * FROM t_disposisi_kabalai WHERE id_sm = '$idu'")->result();	
		$a['datpil3']	= $this->db->query("SELECT * FROM t_disposisi_kabid WHERE id_sm = '$idu'")->result();	
		$a['datpil4']	= $this->db->query("SELECT * FROM t_disposisi_kasie WHERE id_sm = '$idu'")->result();
		$this->load->view('admin/cetak/f_cetak_disposisi', $a);
											}
		
		
		public function disposisi_cetak_loka() 	{
		$idu = $this->uri->segment(3);
		$a['datpil1']	= $this->db->query("SELECT * FROM t_surat_masuk_loka WHERE id_sm = '$idu'")->row();	
		$this->load->view('admin/cetak_loka/f_cetak_disposisi_loka', $a);}
	
	
		public function cetak_tugas() 	{
		$idu = $this->uri->segment(3);
		
		$a['datpil1']	= $this->db->query("SELECT * FROM t_surat_tugas WHERE id_st = '$idu'")->row();	
		$a['datpil2']	= $this->db->query("SELECT * FROM t_surat_tugas_detail WHERE id_st = '$idu'")->result();	
		
		$this->load->view('admin/cetak/f_cetak_tugas', $a);}
	
		public function cetak_tugas_terlampir() 	{
			$idu = $this->uri->segment(3);
			
			$a['datpil1']	= $this->db->query("SELECT * FROM t_surat_tugas WHERE id_st = '$idu'")->row();	
			$a['datpil2']	= $this->db->query("SELECT * FROM t_surat_tugas_detail WHERE id_st = '$idu'")->result();	
			
			$this->load->view('admin/cetak/f_cetak_tugas_terlampir', $a);}

		public function cetak_spd_depan() {
	
		$idu = $this->uri->segment(3);
		$a['datpil1']	= $this->db->query("SELECT * FROM data_surat_tugas WHERE id = '$idu'")->row();	
		$a['datpil2']	= $this->db->query("SELECT * FROM data_surat_tugas WHERE id = '$idu'")->result();
	
		$this->load->view('admin/cetak/f_cetak_spd_depan', $a);}
	
		public function cetak_spd_belakang() {
	
		$idu = $this->uri->segment(3);
		$a['datpil1']	= $this->db->query("SELECT * FROM data_surat_tugas WHERE id = '$idu'")->row();	
		$a['datpil2']	= $this->db->query("SELECT * FROM data_surat_tugas WHERE id = '$idu'")->result();
	
		$this->load->view('admin/cetak/f_cetak_spd_belakang', $a);
		}
		public function cetak_tugas_loka() 	{
		$idu = $this->uri->segment(3);
		
		$a['datpil1']	= $this->db->query("SELECT * FROM t_surat_tugas_loka WHERE id_st = '$idu'")->row();	
		$a['datpil2']	= $this->db->query("SELECT * FROM t_surat_tugas_detail_loka WHERE id_st = '$idu'")->result();	
		$this->load->view('admin/cetak_loka/f_cetak_tugas_loka', $a);}
	
		public function cetak_spd_depan_loka() {
	
		$idu = $this->uri->segment(3);
		$a['datpil1']	= $this->db->query("SELECT * FROM data_surat_tugas_loka WHERE id = '$idu'")->row();	
		$a['datpil2']	= $this->db->query("SELECT * FROM data_surat_tugas_loka WHERE id = '$idu'")->result();
	
		$this->load->view('admin/cetak_loka/f_cetak_spd_depan_loka', $a);}
		
		public function cetak_spd_belakang_loka() {
	
		$idu = $this->uri->segment(3);
		$a['datpil1']	= $this->db->query("SELECT * FROM data_surat_tugas_loka WHERE id = '$idu'")->row();	
		$a['datpil2']	= $this->db->query("SELECT * FROM data_surat_tugas_loka WHERE id = '$idu'")->result();
	
		$this->load->view('admin/cetak_loka/f_cetak_spd_belakang_loka', $a);
		}
	
		public function drpd_cetak_pdf() 	{
			$idu = (decrypt_url ($this->uri->segment(3)));
			$a['data_drpd']	= $this->db->query("SELECT *, sum(view_planning.total_trans) AS total_all_transport, sum(view_planning.total_uh) AS total_all_uh, sum(view_planning.total_inap) AS total_all_inap, sum(view_planning.total_all) AS total_all_all FROM view_planning where id_pegawai = '".$this->session->userdata('admin_id')."' group by id_pegawai, id_planning")->row();	
			$a['data_pegawai']	= $this->db->query("SELECT * FROM tb_planning_detail WHERE id_planning = '$idu'")->result();	
			$a['data_anggaran']	= $this->db->query("SELECT * FROM view_planning WHERE id_planning = '$idu'")->result();
			$this->load->library('pdf');
		
			$html = $this->load->view('admin/cetak/f_cetak_drpd_pdf', $a,  true);
			$this->pdf->createPDF($html, 'mypdf', false);
			
			
		}
		public function drpd_cetak() 	{
			$idu = (decrypt_url ($this->uri->segment(3)));
			$a['data_drpd']	= $this->db->query("SELECT *, sum(view_planning.total_trans) AS total_all_transport, sum(view_planning.total_uh) AS total_all_uh, sum(view_planning.total_inap) AS total_all_inap, sum(view_planning.total_all) AS total_all_all FROM view_planning where id_pegawai = '".$this->session->userdata('admin_id')."' group by id_pegawai, id_planning")->row();	
			$a['data_pegawai']	= $this->db->query("SELECT * FROM tb_planning_detail WHERE id_planning = '$idu'")->result();	
			$a['data_anggaran']	= $this->db->query("SELECT * FROM view_planning WHERE id_planning = '$idu'")->result();
			
		$this->load->view('admin/cetak/f_cetak_drpd', $a);
			
			
			
		}
	//===============================//
	
	
	public function manage_admin() {
		if ($this->session->userdata('admin_valid') == FALSE && $this->session->userdata('admin_id') == "") {
			redirect("admin/login");
		}
		
		/* pagination */	
		$total_row		= $this->db->query("SELECT * FROM t_admin")->num_rows();
		$per_page		= 1000000;
		
		$awal	= $this->uri->segment(4); 
		$awal	= (empty($awal) || $awal == 1) ? 0 : $awal;
		
		//if (empty($awal) || $awal == 1) { $awal = 0; } { $awal = $awal; }
		$akhir	= $per_page;
		
		$a['pagi']	= _page($total_row, $per_page, 4, base_url()."admin/manage_admin/p");
		
		//ambil variabel URL
		$mau_ke					= $this->uri->segment(3);
		$idu					= $this->uri->segment(4);
		
		$cari					= addslashes($this->input->post('q'));

		//ambil variabel Postingan
		$idp					= addslashes($this->input->post('idp'));
		$username				= addslashes($this->input->post('username'));
		$password				= md5(addslashes($this->input->post('password')));
		$nama					= addslashes($this->input->post('nama'));
		$nip					= addslashes($this->input->post('nip'));
		$level					= addslashes($this->input->post('level'));
		$detail_level					= addslashes($this->input->post('detail_level'));

		
		$cari					= addslashes($this->input->post('q'));

		
		if ($mau_ke == "del") {
			$this->db->query("DELETE FROM t_admin WHERE id = '$idu'");
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data has been deleted </div>");
			redirect('admin/manage_admin');
		
		} else if ($mau_ke == "add") {
			$a['page']		= "akun/f_manage_admin";
		} else if ($mau_ke == "edt") {
			$a['datpil']	= $this->db->query("SELECT * FROM t_admin WHERE id = '$idu'")->row();	
			$a['page']		= "akun/f_manage_admin";
		} else if ($mau_ke == "act_add") {	
			$this->db->query("INSERT INTO t_admin VALUES (NULL, '$username', '$password', '$nama', '$nip', '$level','$detail_level')");
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data has been added</div>");
			redirect('admin/manage_admin');
		} else if ($mau_ke == "act_edt") {
			if ($password = md5("-")) {
				$this->db->query("UPDATE t_admin SET username = '$username', nama = '$nama', nip = '$nip', level = '$level', detail_level = '$detail_level' WHERE id = '$idp'");
			} else {
				$this->db->query("UPDATE t_admin SET username = '$username', password = '$password', nama = '$nama', nip = '$nip', level = '$level', detail_level= '$detail_level' WHERE id = '$idp'");
			}
			
			$this->session->set_flashdata("k", "<div class=\"alert alert-success\" id=\"alert\">Data has been updated </div>");			
			redirect('admin/manage_admin');
		} else {
			$a['data']		= $this->db->query("SELECT * FROM t_admin  Order By id desc LIMIT $awal, $akhir ")->result();
			$a['page']		= "akun/l_manage_admin";
		}
		
		
	
		
		$this->load->view('admin/aaa', $a);
	}
	public function ubah_passwod() {
		if ($this->session->userdata('admin_valid') == FALSE && $this->session->userdata('admin_id_user') == "") {
			redirect("sistem/login");
		}
		
		$ke				= $this->uri->segment(3);
		$id_user			= $this->session->userdata('admin_id_user');
		
		//var post
		$p1				= md5($this->input->post('p1'));
		$p2				= md5($this->input->post('p2'));
		$p3				= md5($this->input->post('p3'));
		
		if ($ke == "simpan") {
			$cek_password_lama	= $this->db->query("SELECT password FROM t_admin WHERE id_user = $id_user")->row();
			//echo 
			
			if ($cek_password_lama->password != $p1) {
				
				$this->session->set_flashdata("k_passwod", "<div class=\"alert alert-danger\" id=\"alert\">Password Lama Tidak Sama </div>");			
				redirect('sistem/ubah_passwod');
			} else if ($p2 != $p3) {
				$this->session->set_flashdata("k_passwod", "<div class=\"alert alert-danger\" id=\"alert\">Password Baru 1 dan 2 tidak cocok </div>");			
				redirect('sistem/ubah_passwod');
			} else {
				$this->db->query("UPDATE t_admin SET password = '$p3' WHERE id_user = $id_user");
				$this->session->set_flashdata("k_passwod", "<div class=\"alert alert-success\" id=\"alert\">Password berhasil diperbaharui </div>");			
				redirect('sistem/ubah_passwod');
			}
		} else {
			$a['data_notif_verif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Tidak Ada Kendala'")->row();
			$a['data_notif_unverif']	= $this->db->query("SELECT *, Count(verif) as hitung FROM tb_progres WHERE verif = '0' AND kendala ='Ada Kendala'")->row();
			
			$a['page']		= "manage/f_passwod";
		}
		
		$this->load->view('sistem/aaa', $a);
	}
	
	//login
	public function login() {
		$this->load->view('sistem/login');
	}
	
	public function do_login() {
		$u 		= str_replace("'", "", htmlspecialchars($this->input->post('u'), ENT_QUOTES));
		
		$ta 	= $this->security->xss_clean($this->input->post('ta'));
       	$p 		= md5($this->security->xss_clean($this->input->post('p')));
		$q 	= $this->security->xss_clean($this->input->post('q'));
         
		$qq_cek	= $this->db->query("SELECT * FROM t_admin WHERE username = '".$u."' AND password = '".$p."' AND level = '".$q."'");
		$j_cek	= $qq_cek->num_rows();
		$de_cek	= $qq_cek->row();
		//echo $this->db->last_query();
		
        if($j_cek == 1) {
            $data = array(
                    'admin_id_user' => $de_cek->id_user,
                    'admin_username' => $de_cek->username,
					'admin_level' => $de_cek->level,
                    'admin_nama_lengkap' => $de_cek->nama_lengkap,
					'admin_nama_panggilan' => $de_cek->nama_panggilan,
					'admin_kampus' => $de_cek->kampus,
					'admin_semester' => $de_cek->semester,
                    'admin_prodi' => $de_cek->prodi,
					'admin_asal' => $de_cek->asal,
					'admin_no_wa' => $de_cek->no_wa,
					'admin_coba' => true
                   );
            $this->session->set_userdata($data);
            redirect('sistem');
		
        } else {	
			$this->session->set_flashdata("k", "<div id=\"alert\" class=\"alert alert-error\">username atau password salah</div>");
			redirect('sistem/login');
		}
	}
	
	

	public function logout(){
        $this->session->sess_destroy();
		redirect('sistem/login');
    }
	
	public function get_autocomplete(){
        if (isset($_GET['term'])) {
            $result = $this->user_model->search_blog($_GET['term']);
            if (count($result) > 0) {
            foreach ($result as $row1)
                $arr_result[] = $row1->kode;
                echo json_encode($arr_result);
            }
        }
    }
	
	public function get_lengkap(){
    if (isset($_GET['term'])) {
        $result = $this->user_model->lengkap($_GET['term']);
        if (count($result) > 0) {
            foreach ($result as $row)
                $arr_result[] = array(
                    'label'         => $row->nama,
                    'kuasa'   => $row->kuasa,
             );
                echo json_encode($arr_result);
        }
    }
}
	public function get_kwitansi(){
		if (isset($_GET['term'])) {
			$result = $this->user_model->kwitansi($_GET['term']);
			if (count($result) > 0) {
				foreach ($result as $row)
					$arr_result[] = array(
						'label'         => $row->id_st,
						'id_perjadin'   => $row->id_perjadin,
				 );
					echo json_encode($arr_result);
			}
		}
	}
	
	public function get_perjadin($id=0){
		#Saving...
		$this->db->simple_query('SET sql_mode ="" ');
		$items=$this->db->from('view_surat_tugas')->where('id_st', $id)->get()->row();
		$data['nilai_id_perjadin']=$items->id_perjadin;
		$data['nilai_id_st']=$items->id_st;
		
		die(json_encode($data));
   }
  
   public function get_umkm($id=0){
	#Saving...
	$this->db->simple_query('SET sql_mode ="" ');
	$items=$this->db->query('SELECT * FROM view_left_join_umkm where id_proses IS NULL ')->row();
	$data['nilai_id_umkm']=$items->id_umkm;
	$data['nilai_nama_usaha']=$items->nama_usaha;

	
	die(json_encode($data));
}
public function get_kwitansi_darat($id=0){
	#Saving...
	$this->db->simple_query('SET sql_mode ="" ');
	$items=$this->db->query('SELECT * FROM view_kwitansi_darat where nama_ppk != "" AND transportasi = "Angkutan Darat" AND  id_kwitansi IS NULL AND username = "'.$this->session->userdata('admin_username').'"')->row();
	$data['nilai_id_perjadin']=$items->id_perjadin;

	
	die(json_encode($data));
}
	public function get_lengkap_loka(){
    if (isset($_GET['term'])) {
        $result = $this->user_model->lengkap_loka($_GET['term']);
        if (count($result) > 0) {
            foreach ($result as $row)
                $arr_result[] = array(
                    'label'         => $row->nama,
                    'kuasa'   => $row->kuasa,
             );
                echo json_encode($arr_result);
        }
    }
	}
	public function get_ppk(){
        if (isset($_GET['term'])) {
            $result = $this->user_model->search_ppk($_GET['term']);
            if (count($result) > 0) {
            foreach ($result as $row)
                $arr_result[] = $row->nama_ppk;
                echo json_encode($arr_result);
            }
        }
    }
public function get_pegawai(){
   if (isset($_GET['term'])) {
        $result = $this->user_model->pegawai($_GET['term']);
        if (count($result) > 0) {
            foreach ($result as $row)
                $arr_result[] = array(
					'label'         => $row->nama,
					'nip'        	=> $row->nip,
					'username'      => $row->username,
					'pangkat'   	=> $row->pangkat,
					'jabatan'   	=> $row->jabatan,
					
             );
                echo json_encode($arr_result);
        }
    }
	}
}
